function PortalMenu_ChatCommandHandler(msg)
	PortalMenu_Initialize();
	PortalMenuMainFrame:Show();
end

local PortalMenu_Buttons = { PortalMenuMainFrameButton1 }

local locale = GetLocale();
local LocaleTeleport = "Teleport: ";
local LocalePortal = "Portal: ";
local LocaleHearthstone = "Hearthstone";
local LocaleExit = "Exit";
local LocaleMinutes = "%dmin.";
local LocaleSeconds = "%dsec.";
if (locale == "deDE") then
	LocaleTeleport = "Teleportieren: ";
	LocalePortal = "Portal: ";
	LocaleHearthstone = "Ruhestein";
	LocaleExit = "Verlassen";
end

local HearthstoneId = 6948;
local Trinket1Id = 18986;
local Trinket2Id = 18984;

-- Loads the spells into PortalMenu_Spells.
function PortalMenu_LoadSpells()
	PortalMenu_Spells = {
		Teleports = {
		},
		Portals = {
		}
	}
	local id = 1;
	while true do
		local sname, srank = GetSpellName(id, BOOKTYPE_SPELL);
		if not sname then
			break
		end
		local teleport = string.find(sname, LocaleTeleport);
		local portal = string.find(sname, LocalePortal);
		if (teleport or portal) then
			local tbl;
			if (teleport) then
				tbl = PortalMenu_Spells.Teleports;
			else
				tbl = PortalMenu_Spells.Portals;
			end
			table.insert(tbl, { ["ID"] = id, ["Name"] = sname, ["Texture"] = GetSpellTexture(id, BOOKTYPE_SPELL) });
		end
		id = id + 1;
	end	
end

-- Adds a button with the specified spell (see LoadSpells for format).
-- If spell is LocaleHearthstone, the Hearthstone button is added.
-- if spell is one of the trinket ids, the corresponding trinket-button is added, if the trinket is available.
-- If spell is nil, the close button is added.
function PortalMenu_AddButton(index, spell)
	if (index > table.getn(PortalMenu_Buttons)) then
		PortalMenu_Buttons[index] = CreateFrame("Button", "PortalMenuMainFrameButton" .. index, PortalMenuMainFrame, "PortalMenuButtonTemplate");
		PortalMenu_Buttons[index]:SetID(index);
	end
	local button = getglobal("PortalMenuMainFrameButton" .. index);
	if not button then
		return 0
	end
	button:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	
	local id = button:GetID();
	if (id > 1) then
		local name = button:GetName();
		local len = strlen(id);
		name = strsub(name, 1, strlen(name) - len) .. (id - 1);
		-- Position relativ zum Vorgnger setzen
		button:SetPoint("TOP", name, "BOTTOM", 0, 0);
	end	
	
	local text = getglobal("PortalMenuMainFrameButton" .. index .. "ChildrenText");
	local icon = getglobal("PortalMenuMainFrameButton" .. index .. "ChildrenIcon");	
	
	if (spell and spell ~= LocaleHearthstone and type(spell) ~= "number") then
		button:SetAttribute("type1", "spell");
		button:SetAttribute("spell1", spell.Name);
		icon:SetTexture(spell.Texture);
		text:SetText(spell.Name);
	elseif (spell == LocaleHearthstone) then
		button:SetAttribute("type1", "item");
		button:SetAttribute("item", LocaleHearthstone);
		local _, _, _, _, _, _, _, _, _, texture = GetItemInfo(HearthstoneId);
		
		icon:SetTexture(texture);
		
		local start, duration;
		for bag = 1, 5, 1 do
			for slot = 1, GetContainerNumSlots(bag), 1 do
				local link = GetContainerItemLink(bag, slot);
				if (link ~= nil and string.find(link, LocaleHearthstone)) then
					start, duration = GetContainerItemCooldown(bag, slot);
					break;
				end
			end
		end
		local cdstring = "";
		if (start ~= nil and start > 0) then
			local cd = start + duration - GetTime();
			if (cd > 60) then
				cd = cd / 60;
				cdstring = " (" .. string.format(LocaleMinutes, cd) .. ")";
			else
				cdstring = " (" .. string.format(LocaleSeconds, cd) .. ")";
			end
		end
		
		text:SetText(LocaleHearthstone .. ": " .. GetBindLocation() .. cdstring);
	elseif (spell == Trinket1Id or spell == Trinket2Id) then
		-- TODO
		return 0;
	else
		text:SetText(LocaleExit);
	end
	return 1;
end

-- Initializes the menu, including loading the spells.
function PortalMenu_Initialize()
	PortalMenu_LoadSpells();
	
	local i = 1;
	for _, spell in pairs(PortalMenu_Spells.Teleports) do
		PortalMenu_AddButton(i, spell);
		i = i + 1;
	end
	for _, spell in pairs(PortalMenu_Spells.Portals) do
		PortalMenu_AddButton(i, spell);
		i = i + 1;
	end
	i = i + PortalMenu_AddButton(i, LocaleHearthstone);
	i = i + PortalMenu_AddButton(i, Trinket1Id);
	i = i + PortalMenu_AddButton(i, Trinket2Id);
	i = i + PortalMenu_AddButton(i, nil);
	local mf = PortalMenuMainFrame;
	mf:SetHeight((i - 1) * 24 + 32);
end
