-- global SellValues = shortname -> price

EndaraTooltipInfo = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceConsole-2.0", "AceDB-2.0")
EndaraTooltipInfo:RegisterChatCommand(ENDARA_TTI.COMMANDS, ENDARA_TTI.CMD_OPTIONS)
EndaraTooltipInfo:RegisterDB("ETtiDb")
EndaraTooltipInfo:RegisterDefaults("profile", {[ENDARA_TTI.OPTIONS.ENABLE] = true})

function EndaraTooltipInfo:OnInitialize()
    self.GetOpt = function(var) return self.db:get(self.profilePath,var) end
    self.SetOpt = function(var,val) self.db:set(self.profilePath,var,val) end
    self.TogOpt = function(var) return self.db:toggle(self.profilePath,var) end
end

function EndaraTooltipInfo:OnEnable()
	self:SecureHook(GameTooltip, "SetInventoryItem", "GameTooltipSetInventoryItem");
	self:SecureHook(GameTooltip, "SetBagItem", "GameTooltipSetBagItem");
	self:SecureHook(GameTooltip, "SetHyperlink", "GameTooltipSetHyperlink");
	self:SecureHook(GameTooltip, "SetLootItem", "GameTooltipSetLootItem");
	self:SecureHook(GameTooltip, "SetQuestItem", "GameTooltipSetQuestItem");
	self:SecureHook(GameTooltip, "SetQuestLogItem", "GameTooltipSetQuestLogItem");
	self:SecureHook(GameTooltip, "SetTradeSkillItem", "GameTooltipSetTradeSkillItem");
	self:SecureHook(GameTooltip, "SetMerchantItem", "GameTooltipSetMerchantItem");
	self:SecureHook(GameTooltip, "SetCraftItem", "GameTooltipSetCraftItem");
	self:SecureHook(GameTooltip, "SetAuctionItem", "GameTooltipSetAuctionItem");
	self:SecureHook(GameTooltip, "SetAuctionSellItem", "GameTooltipSetAuctionSellItem");
	self:SecureHook(GameTooltip, "SetInboxItem", "GameTooltipSetInboxItem");
	self:SecureHook("SetItemRef", "GlobalSetItemRef");
end

function EndaraTooltipInfo:OnDisable()
	self:Unhook(GameTooltip, "SetInventoryItem");
	self:Unhook(GameTooltip, "SetBagItem");
	self:Unhook(GameTooltip, "SetHyperlink");
	self:Unhook(GameTooltip, "SetLootItem");
	self:Unhook(GameTooltip, "SetQuestItem");
	self:Unhook(GameTooltip, "SetQuestLogItem");
	self:Unhook(GameTooltip, "SetTradeSkillItem");
	self:Unhook(GameTooltip, "SetMerchantItem");
	self:Unhook(GameTooltip, "SetCraftItem");
	self:Unhook(GameTooltip, "SetAuctionItem");
	self:Unhook(GameTooltip, "SetAuctionSellItem");
	self:Unhook(GameTooltip, "SetInboxItem");
	self:Unhook("SetItemRef");
end

function EndaraTooltipInfo:GetItemName(hyperlink)
	return string.gsub(hyperlink, "|c%x%x%x%x%x%x%x%x|Hitem:%d-:%d-:%d-:%d-|h%[(.-)%]|h", "%1");
end

function EndaraTooltipInfo:GetItemIdString(hyperlink)
	if (strsub(hyperlink, 1, 5) == "item:") then
		return hyperlink;
	end
	return string.gsub(hyperlink, "|c%x%x%x%x%x%x%x%x|H(item:%d-:%d-:%d-:%d-)|h%[(.-)%]|h", "%1");
end

function EndaraTooltipInfo:GameTooltipSetInventoryItem(gtt, unit, slot, nameOnly)
	local link = GetInventoryItemLink(unit, slot);
	if (link) then
		self:AddStackLine();
	end
end

function EndaraTooltipInfo:GameTooltipSetBagItem(gtt, bagID, slot)
	self:AddStackLine(GetContainerItemLink(bagID, slot));
end

function EndaraTooltipInfo:GameTooltipSetHyperlink(gtt, hyperlink)
	self:AddStackLine(hyperlink);
end

function EndaraTooltipInfo:GameTooltipSetLootItem(gtt, slot)
	self:AddStackLine(GetLootSlotLink(slot));
end

function EndaraTooltipInfo:GameTooltipSetQuestItem(gtt, type, index)
	self:AddStackLine(GetQuestItemLink(type, index));
end

function EndaraTooltipInfo:GameTooltipSetQuestLogItem(gtt, type, index)
	self:AddStackLine(GetQuestLogItemLink(type, index));
end

function EndaraTooltipInfo:GameTooltipSetTradeSkillItem(gtt, skill, reagent)
	if (reagent == nil) then
		self:AddStackLine(GetTradeSkillItemLink(skill));
	else
		self:AddStackLine(GetTradeSkillReagentItemLink(skill, reagent));
	end
end

function EndaraTooltipInfo:GameTooltipSetMerchantItem(gtt, slot)
	self:AddStackLine(GetMerchantItemLink(slot));
end

function EndaraTooltipInfo:GameTooltipSetCraftItem(gtt, skill, reagent)
	if (reagent == nil) then
		self:AddStackLine(GetCraftItemLink(skill));
	else
		self:AddStackLine(GetCraftReagentItemLink(skill, reagent));
	end
end

function EndaraTooltipInfo:GameTooltipSetAuctionItem(gtt, type, index)
	self:AddStackLine(GetAuctionItemLink(type, index));
end

function EndaraTooltipInfo:GameTooltipSetAuctionSellItem(gtt)
	local name, texture, Qty, quality, canUse, price = GetAuctionSellItemInfo();
    if (name) then
		for bag = 0, 4, 1 do
			size = GetContainerNumSlots(bag);
			if (size) then
				for slot = size, 1, -1 do
					local link = GetContainerItemLink(bag, slot);
					if (link) then
						local nameTS = self:GetItemName(link);
						if (nameTS and nameTS == name) then
							self:AddStackLine(link);
							return nil;
						end
					end
				end
			end
		end
	end
end

function EndaraTooltipInfo:GameTooltipSetInboxItem(gtt, index)
	
end

function EndaraTooltipInfo:GlobalSetItemRef(itemLink, name, button)

	if(not itemLink or not name or not ItemRefTooltip) then return nil; end

	--we need to weed out item links and player tooltips.
	if( strsub(itemLink, 1, 6) ~= "Player" ) then
		if( ItemRefTooltip:IsVisible() and itemLink) then
			EndaraTooltipInfo:AddStackLine(itemLink, ItemRefTooltip);
		end
	end	
end

function EndaraTooltipInfo:AddStackLine(hyperlink, tooltip)
	if (hyperlink ~= nil) then
		if (tooltip == nil) then
			tooltip = GameTooltip;
		end
		local itemIDString = self:GetItemIdString(hyperlink);
		local _, _, _, _, _, _, _, stackCount = GetItemInfo(itemIDString);
		if (stackCount and stackCount > 1) then
			tooltip:AddLine(ENDARA_TTI.TEXT.ITEMS_STACKABLE .. ": " .. stackCount, 1, 0.8, 0);
		end
		tooltip:Show();
	end
end

function EndaraTooltipInfo:OnShow()
end

function EndaraTooltipInfo:OnHide()
end

function EndaraTooltipInfo:OnLoad()

end

function EndaraTooltipInfo:ToggleEnable()
	if (self.TogOpt(ENDARA_TTI.OPTIONS.ENABLE)) then
		self:Enable();
	else
		self:Disable();
	end
	self.cmd:status(ENDARA_TTI.OPTIONS.TEXT.ENABLE, self.GetOpt(ENDARA_TTI.OPTIONS.ENABLE), ACEG_MAP_ONOFF)
end

--EndaraTooltipInfo:RegisterForLoad();